<?php
/*
INDEX.PHP
Main user management page
*/
// Initialize the session
ob_start();
session_start();

include($_SERVER["DOCUMENT_ROOT"] . "/source/lu_connect.php");
 
 $loggedin=$_SESSION["username"];

// If session variable is not set it will redirect to login page
if(!isset($_SESSION['user']) || empty($_SESSION['user']) || ($_SESSION['role']>1)){
  header("location: ../index.php");
  exit;
}
 // select all user detail
 $ret=mysqli_query($conn, "SELECT * FROM users");
 $usr=mysqli_query($conn, "SELECT * FROM roles");
 $usr2=mysqli_query($conn, "SELECT * FROM roles");
 $usr3=mysqli_query($conn, "SELECT * FROM roles");
 $usr4=mysqli_query($conn, "SELECT * FROM roles");
 $row=mysqli_fetch_array($ret);
?>
<!DOCTYPE html>
<html lang="en">
    <head>
		<meta name="viewport" content="width=device-width, initial-scale=1">
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
            <title>User Management - <?php echo $loggedin; ?></title>
				<link rel="shortcut icon" href="../images/favicon.png" type="img/x-icon">
				<link rel="stylesheet" href="https://www.w3schools.com/w3css/4/w3.css">
                <link rel="stylesheet" href="../css/table.css" type="text/css"  />
				<link rel="stylesheet" href="../css/bootstrap.min.css" type="text/css"  />	
	<script>
		function openMember(evt, jobName) {
		  var i, x, tablinks;
		  x = document.getElementsByClassName("member");
		  for (i = 0; i < x.length; i++) {
			 x[i].style.display = "none";
		  }
		  tablinks = document.getElementsByClassName("tablink");
		  for (i = 0; i < x.length; i++) {
			 tablinks[i].className = tablinks[i].className.replace(" w3-red", "");
		  }
		  document.getElementById(jobName).style.display = "block";
		  evt.currentTarget.className += " w3-red";
		}
	</script>
	<script type="text/javascript">
		// place your images in this array
		var random_images_array = ['user1.png', 'user2.png', 'user3.png', 'user4.png', 'user5.png'];
		
		function getRandomImage(imgAr, path) {
			path = path || '../images/'; // default path here
			var num = Math.floor( Math.random() * imgAr.length );
			var img = imgAr[ num ];
			var imgStr = '<img src="' + path + img + '" width="65" height="66" alt="">';
			document.write(imgStr); document.close();
		}
	</script>
	<script type="text/javascript">
		//Deletion confirmation
		function DeleteItem(){
			var a = confirm("Are you sure to delete this record?");
				if(a)
					return true;
				else
					return false;
		}
     </script>
     <script src="../js/zxcvbn.js"></script>
</head>
<body>
	<div class="w3-top">
		<div class="w3-bar w3-padding-large w3-black w3-card">
			<h2>
				<script type="text/javascript">getRandomImage(random_images_array);
				</script>  
				User Management
				<script type="text/javascript">getRandomImage(random_images_array);
				</script>
			</h2>
		</div>
		<div class="w3-sidebar w3-bar-block w3-black w3-card" style="width:130px">
			<nav>
				<button id="defaultOpen" onclick="menuFunction('User')" class="w3-button w3-block w3-black w3-left-align">
					<h4>User Management</h4></button>
						<div id="User" class="w3-container w3-hide">
							<button class="w3-bar-item w3-button tablink" onclick="openMember(event, 'Manage')">Manage</button> 
							<button class="w3-bar-item w3-button tablink" onclick="openMember(event, 'Member')">Add</button>
						</div>
				<button onclick="menuFunction('Role')" class="w3-button w3-block w3-black w3-left-align">
					<h4>Role Management</h4></button>
						<div id="Role" class="w3-container w3-hide">
							<button class="w3-bar-item w3-button tablink" onclick="openMember(event, 'ManageRoles')">Manage</button>
							<button class="w3-bar-item w3-button tablink" onclick="openMember(event, 'AddRoles')">Add</button>
						</div>
			</nav>
		</div>
	</div>
	<div>
		<div id="Manage" class="tabcontent member">
			<form class="form-horizontal">
				<span class="center"><strong>* <font color="FF0000">Role selection hides selected roles</strong></font></span>
					<div class="divTable center minor">						
						<div class="divTableBody">
							<div class="divTableRow">
							<?php
							while ($rowu = mysqli_fetch_assoc($usr)){
								echo "<div class='divTableHead'><label for='roleType'>" . stripslashes($rowu['role_name']) . "</label></div>";
							}
							?>
							</div>
							<div class="divTableRow">
								<?php
									while ($rowu2 = mysqli_fetch_assoc($usr2)){
										echo "<div class='divTableCell'><input name='role" . stripslashes($rowu2['role_id']) . "' type='checkbox' value='role" . stripslashes($rowu2['role_id']) . "' id='role" . stripslashes($rowu2['role_id']) . "'/></div>";
									}
								?>	
							</div>
						</div>
					</div>
			</form>
			<form class="form-horizontal">
				<fieldset>
					<div class="divTable center">
						<table id='userTable' class="divTableBody">
							<thead>
								<tr class="divTableRow">
									<th class="divTableHead">
										<label for="username">Username</label>
									</th>
									<th class="divTableHead">
										<label for="email">Email</label>
									</th>
									<th class="divTableHead">
										<label for="password">Password</label>
									</th>
									<th class="divTableHead">
										<label for="display">Display Name</label>
									</th>
									<th class="divTableHead">
										<label for="roles">User Role</label>
									</th>
									<th class="divTableHead">
										<label for="since">Subscribe Date</label>
									</th>
									<th class="divTableHead">
										<label for="until">Subscribed Until</label>
									</th>
									<th class="divTableHead">
										<label for="manage">Manage</label>
									</th>
								</tr>
							</thead>
							<tbody>
							<?php
								while (list($user_id,$username,$password,$user_email,$display_name,$user_role,$user_since,$user_expire) = $ret->fetch_array(MYSQLI_NUM)){ ?>
									<tr id="manage_members" class="divTableRow role<?php echo $user_role ?>" data-row-id="<?php echo $user_id; ?>"><td id="<?php echo $username; ?>" class="divTableCell editable-col" col-index='1' contenteditable="true" oldValue="<?php echo $username; ?>"><?php echo $username; ?></td><td id="<?php echo $user_email; ?>" class='divTableCell editable-col' col-index='3' contenteditable="true" oldValue="<?php echo $user_email; ?>"><?php echo $user_email; ?></td><td class='divTableCell' col-index='2'> ********* </td><td id="<?php echo $display_name; ?>" class='divTableCell editable-col' col-index='4' contenteditable="true" oldValue="<?php echo $display_name; ?>"><?php echo $display_name; ?></td><td id="<?php echo $user_role; ?>" class="divTableCell" col-index='5'><?php $usr=mysqli_query($conn, "SELECT roles.* FROM `roles` WHERE roles.role_id = $user_role"); $usr2 = mysqli_fetch_assoc($usr); echo $usr2['role_name']; ?></td><td id="<?php echo $user_since; ?>" class="divTableCell" col-index='6'><?php echo $user_since; ?></td><td id="<?php echo $user_expire; ?>" class="divTableCell editable-col" col-index='7' contenteditable="true" oldValue="<?php echo $user_expire; ?>"><?php echo $user_expire; ?></td><td class="divTableCell"><a href="lu_delete.php?id=<?php echo $user_id; ?>" onclick="return DeleteItem();" class="btn btn-danger btn-xs" role="button">Delete</a> </td></td>
							<?php
								}
							?>
								</tr>
							</tbody>
						</table>
				</fieldset>
			</form>
		</div>
		<div id="Member" class="tabcontent member">
			<form class="form-horizontal" method="post" action="lu_register.php" name="registration" autocomplete="off">
				<fieldset>
					<div class="divTable center">
						<div class="divTableBody">
							<div class="divTableRow">
								<div class="divTableHead">
									<label for="username">Username</label>
								</div>
								<div class="divTableHead">
									<label for="email">Email</label>
								</div>
								<div class="divTableHead">
									<label for="password">Password</label>
								</div>
								<div class="divTableHead">
									<label for="display">Display Name</label>
								</div>
								<div class="divTableHead">
									<label for="roles">User Role</label>
								</div>
								<div class="divTableHead">
									<label for="since">Subscribe Date</label>
								</div>
								<div class="divTableHead">
									<label for="until">Subscribed Until</label>
								</div>
							</div>
							<div class="divTableRow">
								<div class="divTableCell">
									<span><input id="username" name="username" type="text" required=""></span>
								</div>
								<div class="divTableCell">
									<span><input id="email" name="email" type="email" required=""></span>
								</div>
								<div class="divTableCell">
									<span>
									    <input id="password" name="password" type="password" required="">
									</span>
									<div id="PasswordCheck">
                                    	<meter max="4" id="password-strength-meter">
                                    	</meter>
                                    	<div id="message">
                                    		<p id="password-strength-text"></p>
                                    		<p id="letter" class="invalid">A <b>lowercase</b> letter</p>
                                    		<p id="capital" class="invalid">A <b>capital (uppercase)</b> letter</p>
                                    		<p id="number" class="invalid">A <b>number</b></p>
                                    		<p id="characters" class="invalid">A <b>special character</b></p>
                                    		<p id="length" class="invalid">Minimum <b>8 characters</b></p>
                                    	</div>
                                    </div>
								</div>
								<div class="divTableCell">
									<span><input id="display" name="display" type="text"></span>
								</div>
								<div class="divTableCell">
								    <select name="roles">
								        <option value=''>---- Select Role----</option>
									<?php
										while ($rowu3 = mysqli_fetch_assoc($usr3)){
											echo "<option value='" . stripslashes($rowu3['role_id']) . "'>" . stripslashes($rowu3['role_name']) . "</option>";
										}
									?>
									</select>						
								</div>
								<div class="divTableCell">
									<span><input id="since" name="since" type="date" placeholder="mm/dd/yy"></span>
								</div>
								<div class="divTableCell">
									<span><input id="until" name="until" type="date" placeholder="mm/dd/yy"></span>
								</div>
							</div>
							<div class="divTableRow">
								<div class="divTableCell">
								</div>
								<div class="divTableCell">
								</div>
								<div class="divTableCell">
									<button type="submit" class="btn btn-md btn-primary" name="btn-signup">Add User</button>
								</div>
								<div class="divTableCell">
								</div>
								<div class="divTableCell">
									<button type="reset" class="btn btn-md btn-warning" name="btn-signup">Reset Form</button>
								</div>
								<div class="divTableCell">
								</div>
								<div class="divTableCell">
								</div>
							</div>
						</div>
					</div>
				</fieldset>
			</form> 
		</div>
		<div id="ManageRoles" class="tabcontent member">
			<form class="form-horizontal">
					<div class="divTable center minor">						
						<div class="divTableBody">
							<div class="divTableRow">
							</div>
						</div>
					</div>
			</form>
			<form class="form-horizontal">
				<fieldset>
					<div class="divTable center">
					<table id='roleTable' class="divTableBody">
						<thead>
							<tr class="divTableRow">
								<th class="divTableHead">
									<label for="rolename">Role Name</label>
								</th>
								<th class="divTableHead">
									<label for="roleid">Role ID</label>
								</th>
								<th class="divTableHead">
									<label for="managerole">Manage</label>
								</th>
							</tr>
						</thead>
						<tbody>
						<?php
								while ($rowu2 = mysqli_fetch_assoc($usr4)){
						?>
								<tr id="manage_roles" class="divTableRow role<?php echo $rowu2['role_id']; ?>" data-row-id="<?php echo $rowu2['role_id']; ?>"><td id="<?php echo $rowu2['role_name']; ?>" col-index='1' class="divTableCell editable-col" contenteditable="true" oldValue="<?php echo $rowu2['role_name']; ?>"><?php echo $rowu2['role_name']; ?></td><td col-index='0' class="divTableCell"><?php echo $rowu2['role_id']; ?></td><td class="divTableCell"><a href="lu_delete.php?roleID=<?php echo $rowu2['role_id']; ?>" onclick='return DeleteItem();' class="btn btn-danger btn-xs" role="button">Delete</a> </td></td>
						<?php
							}
						?>
							</tr>
						</tbody>
					</table>
				</fieldset>
				</div>
			</form>
		</div>
		<div id="AddRoles" class="tabcontent member">
			<form class="form-horizontal" method="post" action="lu_register.php" name="roleadd" autocomplete="off">
				<fieldset>
					<div class="divTable center">
						<div class="divTableBody">
							<div class="divTableRow">
								<div class="divTableHead">
									<label for="rolename">Role Name</label>
								</div>
								<div class="divTableHead">
									<label for="roleID">Role ID</label>
								</div>
							</div>
							<div class="divTableRow">
								<div class="divTableCell">
									<span><input id="rolename" name="rolename" type="text" required=""></span>
								</div>
								<div class="divTableCell">
									<span><input type="hidden" name="roleID" id="roleID" value="<?php $rolequery = mysqli_query($conn, "SELECT role_id FROM roles ORDER BY role_id DESC LIMIT 1"); $lastid = mysqli_fetch_assoc($rolequery); echo $lastid['role_id']+1; ?>">Automatic</span>
								</div>
							</div>
							<div class="divTableRow">
								<div class="divTableCell">
									<button type="submit" class="btn btn-md btn-primary" name="btn-role">Add Role</button>
								</div>
								<div class="divTableCell">
									<button type="reset" class="btn btn-md btn-warning" name="btn-role">Reset Form</button>
								</div>
							</div>
						</div>
					</div>
				</fieldset>
			</form> 
		</div>
	</div>
	<script type="text/javascript" src="../js/requirements.js"></script>
	<script type="text/javascript" src="../js/jquery.min.js"></script>
	<script type="text/javascript" src="../js/jQuery3.3.1.js"></script>
	<script type="text/javascript" src="../js/jquery.validate.min.js"></script>
	<script type="text/javascript" src="../js/form-validation.js"></script>
	<script type="text/javascript" src="//cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js"></script>
	<script type="text/javascript">
		$(document).ready(function(){
			$('input[type="checkbox"]').click(function(){
				var inputValue = $(this).attr("value");
				$("." + inputValue).toggle();
			});
			$('#userTable').DataTable({
				"searching": false,
				"order": [[ 4, 'asc' ]]
			});
			$('#roleTable').DataTable({
				"searching": false,
				"order": [[ 1, 'asc' ]]
			});
		});
	</script>
	<script type="text/javascript">
	$(document).ready(function(){
	  $('td.editable-col').on('focusout', function() {
		data = {};
		data['cell'] = $(this).text()
		data['val'] = $(this).text();
		data['id'] = $(this).parent('tr').attr('data-row-id');
		data['table'] = $(this).parent('tr').attr('id');
		data['index'] = $(this).attr('col-index');
		  if($(this).attr('oldVal') === data['val'])
		return false;
			var a = document.getElementById(data['cell']);
			$(a).css("background","#502c2c url(loader.gif) no-repeat center");
		$.ajax({
			  url: "lu_edit.php",
			  cache:false,
			  data: data,
			  contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
			  type: "POST",
			  success: function(response)
			  {
				if(response.status) {
					var a = document.getElementById(data['cell']);
					$(a).css("background","");
						console.log("Something went wrong");
				} else {
					var a = document.getElementById(data['cell']);
					$(a).css("background","#502c2c");
						console.log(data['table']);
				}
			  }
			});
			
	  });
	});
	</script>
	<script>
	function menuFunction(id) {
		var x = document.getElementById(id);
		if (x.className.indexOf("w3-show") == -1) {
			x.className += " w3-show";
            x.previousElementSibling.className = 
            x.previousElementSibling.className.replace("w3-black", "w3-sand");
		} else { 
			x.className = x.className.replace(" w3-show", "");
            x.previousElementSibling.className = 
            x.previousElementSibling.className.replace("w3-sand", "w3-black");
		}
	}
	</script>
	<script>
    var myInput = document.getElementById("password");
    var letter = document.getElementById("letter");
    var capital = document.getElementById("capital");
    var number = document.getElementById("number");
    var character = document.getElementById("characters");
    var length = document.getElementById("length");
    
    // When the user clicks on the password field, show the message box
    myInput.onfocus = function() {
      document.getElementById("message").style.display = "block";
    }
    
    // When the user clicks outside of the password field, hide the message box
    myInput.onblur = function() {
      document.getElementById("message").style.display = "none";
    }
    
    // When the user starts to type something inside the password field
    myInput.onkeyup = function() {
      // Validate lowercase letters
      var lowerCaseLetters = /[a-z]/g;
      if(myInput.value.match(lowerCaseLetters)) { 
        letter.classList.remove("invalid");
        letter.classList.add("valid");
      } else {
        letter.classList.remove("valid");
        letter.classList.add("invalid");
    }
    
      // Validate capital letters
      var upperCaseLetters = /[A-Z]/g;
      if(myInput.value.match(upperCaseLetters)) { 
        capital.classList.remove("invalid");
        capital.classList.add("valid");
      } else {
        capital.classList.remove("valid");
        capital.classList.add("invalid");
      }
    
      // Validate numbers
      var numbers = /[0-9]/g;
      if(myInput.value.match(numbers)) { 
        number.classList.remove("invalid");
        number.classList.add("valid");
      } else {
        number.classList.remove("valid");
        number.classList.add("invalid");
      }
    
      // Validate Characters
      var characters = /[@$,<>#:?_*&;]/g;
      if(myInput.value.match(characters)) { 
        character.classList.remove("invalid");
        character.classList.add("valid");
      } else {
        character.classList.remove("valid");
        character.classList.add("invalid");
      }
    
      // Validate length
      if(myInput.value.length >= 8) {
        length.classList.remove("invalid");
        length.classList.add("valid");
      } else {
        length.classList.remove("valid");
        length.classList.add("invalid");
      }
    }
    </script>
	<script>
			// Get the element with id="defaultOpen" and click on it
			document.getElementById("defaultOpen").click();
	</script>
	<a href='../logout.php' class='float' role='button'><img src='../images/logout.png' height='32' width='32' title='Logout'></a>
</body>
</html>
<?php
ob_end_flush();
?>