<?php
/*
LU_EDIT.PHP
Allows user to edit specific entry in database
*/
// Initialize the session
ob_start();
session_start();

include($_SERVER["DOCUMENT_ROOT"] . "/source/lu_connect.php");

// If session variable is not set it will redirect to login page
if(!isset($_SESSION['user']) || empty($_SESSION['user']) || ($_SESSION['role']>1)){
  header("location: ../index.php");
  exit;
}

// creates the edit record form
// since this form is used multiple times in this file, it is a function that is easily reusable
function renderForm($id,$name,$password,$email,$display,$roles,$since,$until,$error,$conn2){
?>
<!DOCTYPE html>
<html lang="en">
    <head>
		<meta name="viewport" content="width=device-width, initial-scale=1">
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
            <title>Edit User - <?php echo $name; ?></title>
				<link rel="shortcut icon" href="../images/favicon.png" type="img/x-icon">
				<link rel="stylesheet" href="https://www.w3schools.com/w3css/4/w3.css">
                <link rel="stylesheet" href="../css/table.css" type="text/css"  />
				<link rel="stylesheet" href="../css/bootstrap.min.css" type="text/css"  />
	<script type="text/javascript">
		// place your images in this array
		var random_images_array = ['user1.png', 'user2.png', 'user3.png', 'user4.png', 'user5.png'];
		
		function getRandomImage(imgAr, path) {
			path = path || '../images/'; // default path here
			var num = Math.floor( Math.random() * imgAr.length );
			var img = imgAr[ num ];
			var imgStr = '<img src="' + path + img + '" width="65" height="66" alt="">';
			document.write(imgStr); document.close();
		}
	</script>
	</head>
	<body>
	<div class="w3-top">
		<div class="w3-bar w3-padding-large w3-black w3-card">
			<h2>
				<script type="text/javascript">getRandomImage(random_images_array);
				</script>  
				User Management
				<script type="text/javascript">getRandomImage(random_images_array);
				</script>
			</h2>
		</div>
		<div class="w3-sidebar w3-bar-block w3-black w3-card" style="width:130px">
			<nav>
				<button id="defaultOpen" onclick="menuFunction('User')" class="w3-button w3-block w3-black w3-left-align">
					<h4>User Management</h4></button>
						<div id="User" class="w3-container w3-hide">
							<button class="w3-bar-item w3-button tablink" onclick="openMember(event, 'Manage')">Manage</button> 
							<button class="w3-bar-item w3-button tablink" onclick="openMember(event, 'Member')">Add</button>
						</div>
				<button onclick="menuFunction('Role')" class="w3-button w3-block w3-black w3-left-align">
					<h4>Manage Roles</h4></button>
						<div id="Role" class="w3-container w3-hide">
							<button class="w3-bar-item w3-button tablink" onclick="openMember(event, 'ManageRoles')">Edit/View</button>
							<button class="w3-bar-item w3-button tablink" onclick="openMember(event, 'AddRoles')">Add</button>
						</div>
			</nav>
		</div>
	</div>
<?php
// if there are any errors, display them
if ($error != ''){
	echo '<div style="padding:4px; border:1px solid red; color:red;">'.$error.'</div>';
}
?>
	<div id="Manage" class="tabcontent member w3-show">
		<form class="form-horizontal" action="" method="post">
			<input type="hidden" name="id" value="<?php echo $id; ?>"/>		
			<fieldset>
				<div class="divTable center">
					<div class="divTableBody">
						<div class="divTableRow">
							<div class="divTableHead">
								<label for="username">Username</label>
							</div>
							<div class="divTableHead">
								<label for="email">Email</label>
							</div>
							<div class="divTableHead">
								<label for="password">Update Password</label>
							</div>
							<div class="divTableHead">
								<label for="display">Display Name</label>
							</div>
							<div class="divTableHead">
								<label for="roles">User Role</label>
							</div>
							<div class="divTableHead">
								<label for="since">Subscribe Date</label>
							</div>
							<div class="divTableHead">
								<label for="until">Subscribed Until</label>
							</div>
						</div>
						<div class="divTableRow">
							<div class="divTableCell">
								<input type="text" id="username" name="username" value="<?php echo $name; ?>" />
							</div>
							<div class="divTableCell">
								<input id="email" name="email" type="email" value="<?php echo $email; ?>" />
							</div>
							<div class="divTableCell">
								<input id="password" name="password" type="password" value="" />
    							<div id="pswd_info">
	    							<h4>Password must meet the following requirements:</h4>
		    							<ul>
			    							<li id="letter" class="invalid">At least <strong>one letter</strong></li>
										    <li id="capital" class="invalid">At least <strong>one capital letter</strong></li>
										    <li id="number" class="invalid">At least <strong>one number</strong></li>
										    <li id="length" class="invalid">Be at least <strong>8 characters</strong></li>
									    </ul>
							    </div>
							</div>
							<div class="divTableCell">
								<input id="display" name="display" type="text" value="<?php echo $display; ?>" />
							</div>
							<div class="divTableCell left">
							    <select name="roles">
            <?php
            	$rolelst = mysqli_query($conn2, "SELECT * FROM roles")
            	or die(mysqli_connect_errno());
            	
            while ($rowbld = mysqli_fetch_assoc($rolelst)){
            		echo "<option value='" . stripslashes($rowbld['role_id']) . "' " . ($roles == $rowbld['role_id'] ? 'selected': '') . ">" . stripslashes($rowbld['role_name']) . "</option>";
            	}
            ?>
                                </select>
							</div>
							<div class="divTableCell">
								<input id="since" name="since" type="date" value="<?php echo $since; ?>" />
							</div>
							<div class="divTableCell">
								<input id="until" name="until" type="date" value="<?php echo $until; ?>" />
							</div>
						</div>
					<div class="divTableRow">
						<div class="divTableCell">
						</div>
						<div class="divTableCell">
						</div>
						<div class="divTableCell">
							<button type="submit" class="btn btn-md btn-success" name="submit" value="Submit">Save Edit</button>
						</div>
						<div class="divTableCell">
						</div>
						<div class="divTableCell">
							<a href='index.php' class='btn btn-warning btn-md' role='button'>Cancel Edit</a>
						</div>
						<div class="divTableCell">
						</div>
						<div class="divTableCell">
						</div>
					</div>
					</div>
				</div>
			</fieldset>
		</form>
	<script type="text/javascript" src="../js/jquery.min.js"></script>
	<script type="text/javascript" src="../js/jQuery1.8.3.js"></script>
	<script type="text/javascript" src="../js/jquery.validate.min.js"></script>
	<script type="text/javascript" src="../js/requirements.js"></script>	
	<script type="text/javascript" src="../js/form-validation.js"></script>
		</div>
	</div>
	</body>
</html>
<?php
}
include($_SERVER["DOCUMENT_ROOT"] . "/source/lu_connect.php");
// check if the form has been submitted. If it has, process the form and save it to the database
if (isset($_POST['submit'])){
	// confirm that the 'id' value is a valid integer before getting the form data
	if (is_numeric($_POST['id'])){
		// get form data, making sure it is valid
		$id = $_POST['id'];
		$name = mysqli_real_escape_string(htmlspecialchars($_POST['username']));
		$email = mysqli_real_escape_string(htmlspecialchars($_POST['email']));
		$password = mysqli_real_escape_string(htmlspecialchars($_POST['password']));
		$display = mysqli_real_escape_string(htmlspecialchars($_POST['display']));
		$roles = mysqli_real_escape_string(htmlspecialchars($_POST['roles']));
		$since = mysqli_real_escape_string(htmlspecialchars($_POST['since']));
		$until = mysqli_real_escape_string(htmlspecialchars($_POST['until']));
// check that firstname/lastname fields are both filled in

		if ($password == ''){
			// clean user inputs to prevent sql injections
			$name = trim($_POST['username']);
			$name = strip_tags($name);
			$name = htmlspecialchars($name);

			$email = trim($_POST['email']);
			$email = strip_tags($email);
			$email = htmlspecialchars($email);

			$password = trim($_POST['password']);
			$password = strip_tags($password);
			$password = htmlspecialchars($password);

			$display = trim($_POST['display']);
			$display = strip_tags($display);
			$display = htmlspecialchars($display);

			$roles = trim($_POST['roles']);
			$roles = strip_tags($roles);
			$roles = htmlspecialchars($roles);

			$since = trim($_POST['since']);
			$since = strip_tags($since);
			$since = htmlspecialchars($since);

			$until = trim($_POST['until']);
			$until = strip_tags($until);
			$until = htmlspecialchars($until);
			
			// save the data to the database
			mysqli_query($conn, "UPDATE users SET username='$name',user_email='$email',display_name='$display',user_role='$roles',user_since='$since',user_expire='$until' WHERE user_id='$id'")
			or die(mysqli_connect_errno());
			// once saved, redirect back to the view page
			header("Location: index.php");
		}
		else{
			// clean user inputs to prevent sql injections
			$name = trim($_POST['username']);
			$name = strip_tags($name);
			$name = htmlspecialchars($name);

			$email = trim($_POST['email']);
			$email = strip_tags($email);
			$email = htmlspecialchars($email);

			$password = trim($_POST['password']);
			$password = strip_tags($password);
			$password = htmlspecialchars($password);

			$display = trim($_POST['display']);
			$display = strip_tags($display);
			$display = htmlspecialchars($display);

			$roles = trim($_POST['roles']);
			$roles = strip_tags($roles);
			$roles = htmlspecialchars($roles);

			$since = trim($_POST['since']);
			$since = strip_tags($since);
			$since = htmlspecialchars($since);

			$until = trim($_POST['until']);
			$until = strip_tags($until);
			$until = htmlspecialchars($until);
			
			// password encrypt using SHA256();
			$password = hash('sha256', $password);
			
			// save the data to the database
			mysqli_query($conn, "UPDATE users SET username='$name',password='$password',user_email='$email',display_name='$display',user_role='$roles',user_since='$since',user_expire='$until' WHERE user_id='$id'")
			or die(mysqli_connect_errno());
			// once saved, redirect back to the view page
			header("Location: index.php");

		}
	}
	else{
		// if the 'id' isn't valid, display an error
		echo 'Invalid User ID';
	}
}
else{
	// if the form hasn't been submitted, get the data from the db and display the form
	// get the 'id' value from the URL (if it exists), making sure that it is valid (checing that it is numeric/larger than 0)
	if (isset($_GET['id']) && is_numeric($_GET['id']) && $_GET['id'] > 0){
		// query db
		$id = $_GET['id'];
		$result = mysqli_query($conn, "SELECT * FROM users WHERE user_id=$id")
		or die(mysqli_connect_errno());
		$row = mysqli_fetch_array($result);
			// check that the 'id' matches up with a row in the databse
		if($row){
			// get data from db
			$name = $row['username'];
			$password = $row['password'];
			$email = $row['user_email'];
			$display = $row['display_name'];
			$roles = $row['user_role'];
			$since = $row['user_since'];
			$until = $row['user_expire'];
			$conn2 = $conn;
				// show form
				renderForm($id,$name,$password,$email,$display,$roles,$since,$until,$error,$conn2);
		}
		else{
			// if no match, display result
			echo "No user found!";
		}
	}
	else{
		// if the 'id' in the URL isn't valid, or if there is no 'id' value, display an error
		echo 'Something odd just happened!';
	}
}
?>