<?php
/*
lu_register.php
Add new user
*/

// Initialize the session
ob_start();
session_start();

include($_SERVER["DOCUMENT_ROOT"] . "/source/lu_connect.php");
include($_SERVER["DOCUMENT_ROOT"] . "/source/lu_functions.php");
 
 $loggedin=$_SESSION["username"];

// If session variable is not set it will redirect to login page
if(!isset($_SESSION['user']) || empty($_SESSION['user']) || ($_SESSION['role']>1)){
  header("location: ../index.php");
  exit;
}

 $error = false;

 if ( isset($_POST['btn-role']) ) {
  
     echo 'hello, '.$_POST['rolename'].'';
  $rolename = trim($_POST['rolename']);
  $rolename = strip_tags($rolename);
  $rolename = htmlspecialchars($rolename);
  
  // basic name validation
  if (empty($rolename)) {
   $error = true;
   $nameError = "Please enter your full name.";
  } else if (strlen($rolename) < 3) {
   $error = true;
   $nameError = "Name must have at least 3 characters.";
  } else if (!preg_match("/^[a-zA-Z ]+$/",$rolename)) {
   $error = true;
   $nameError = "Name must contain alphabets and space.";
  }

  // if there's no error, continue to signup
  if( !$error ) {
   $query = "INSERT INTO roles(role_name) VALUES('$rolename')";
   $res = mysqli_query($conn, $query);
 
   if ($res) {
    $errTyp = "success";
    $errMSG = "Successfully registered, you may login now";
	
    unset($rolename);
	
	// redirect back to the view page
	header("Location: index.php");
	
   } else {
    $errTyp = "danger";
    $errMSG = "Something went wrong, try again later..."; 
    
    // if id isn't set, or isn't valid, redirect back to view page
	header("Location: index.php");
   } 
  }
 
}elseif ( isset($_POST['btn-signup']) ) {
  
  // clean user inputs to prevent sql injections
  $name = trim($_POST['username']);
  $name = strip_tags($name);
  $name = htmlspecialchars($name);
  
  $email = trim($_POST['email']);
  $email = strip_tags($email);
  $email = htmlspecialchars($email);
  
  $password = trim($_POST['password']);
  $password = strip_tags($password);
  $password = htmlspecialchars($password);
  
  $display = trim($_POST['display']);
  $display = strip_tags($display);
  $display = htmlspecialchars($display);
  
  $roles = trim($_POST['roles']);
  $roles = strip_tags($roles);
  $roles = htmlspecialchars($roles);
  
  $since = trim($_POST['since']);
  $since = strip_tags($since);
  $since = htmlspecialchars($since);
  
  $until = trim($_POST['until']);
  $until = strip_tags($until);
  $until = htmlspecialchars($until);
  
  // basic name validation
  if (empty($name)) {
   $error = true;
   $nameError = "Please enter your full name.";
  } else if (strlen($name) < 3) {
   $error = true;
   $nameError = "Name must have at least 3 characters.";
  } else if (!preg_match("/^[a-zA-Z ]+$/",$name)) {
   $error = true;
   $nameError = "Name must contain alphabets and space.";
  }
  
  //basic email validation
  if ( !filter_var($email,FILTER_VALIDATE_EMAIL) ) {
   $error = true;
   $emailError = "Please enter valid email address.";
  } else {
   // check email exist or not
   $query = "SELECT user_email FROM users WHERE user_email='$email'";
   $result = mysqli_query($conn, $query);
   $count = mysqli_num_rows($result);
   if($count!=0){
    $error = true;
    $emailError = "Provided Email is already in use.";
   }
  }
  
  // password validation
  if (empty($password)){
   $error = true;
   $passError = "Please enter password.";
  } else if(strlen($password) < 6) {
   $error = true;
   $passError = "Password must have at least 6 characters.";
  }
  
  // password encrypt using SHA256();
  $password = hash('sha256', $password);
  
  // if there's no error, continue to signup
  if( !$error ) {
   $query = "INSERT INTO users(username,password,user_email,display_name,user_role,user_since,user_expire) VALUES('$name','$password','$email','$display','$roles','$since','$until')";
   $res = mysqli_query($conn, $query);
 
	$uemail = mysqli_real_escape_string($conn, $email);

	$userID = UserID($uemail);
	$UUID = getGUID();
	$token = substr($UUID, 1, -1);
 
	$query = mysqli_query($conn, "INSERT INTO recovery_keys (userID, token) VALUES ($userID, '$token') ");
	$send_mail = send_new_mail($uemail, $token, $name);
 
   if ($res) {
    $errTyp = "success";
    $errMSG = "Successfully registered, you may login now";
	
    unset($name);
    unset($email);
    unset($password);
    unset($display);
    unset($roles);
    unset($since);
    unset($until);
	
	// redirect back to the view page
	header("Location: index.php");
	
   } else {
    $errTyp = "danger";
    $errMSG = "Something went wrong, try again later..."; 
    
    // if id isn't set, or isn't valid, redirect back to view page
	header("Location: index.php");
   } 
  }
 }
 ?>